import { Component, OnInit } from '@angular/core';
import { FormBuilder } from '@angular/forms';
import { Validators } from '@angular/forms';

import { DirectoryService } from '../directory.service';

@Component({
  selector: 'app-directory',
  templateUrl: './directory.component.html',
  styleUrls: ['./directory.component.css'],
  providers: [DirectoryService]
})
export class DirectoryComponent implements OnInit {

  form = this.fb.array([]);
  lastSave: Date|null = null;
  
  createDirectoryEntryForm() {
	return this.fb.group({
		name: ['', Validators.required],
		coordinates: this.fb.group({
			phone: ['', Validators.pattern("[0-9 ]+")],
			email: ['', Validators.email]
		})
	});
  }
  
  addDirectoryEntry(value) {
	let f = this.createDirectoryEntryForm();
	f.setValue(value);
	this.form.push(f);
  }
  
  removeDirectoryEntry(position) {
	this.form.removeAt(position);
  }
  
  save() {
	this.directoryService.saveEntries(this.form.value).subscribe( result => { if (result) this.lastSave = new Date() });
  }
  
  constructor(private directoryService: DirectoryService, private fb: FormBuilder) { }
  
  ngOnInit() {
	this.directoryService.loadEntries().subscribe( value => this.addDirectoryEntry(value) );
  }
  
  ngOnDestroy() {
  }
	
}
