import { Component, OnInit } from '@angular/core';

class Currency {
	// value is the number of units we can buy with one euro
	constructor(public name: string, public value: number) {}
}

class MoneyAmount {
	constructor (public quantity: number, public currency: Currency) {}
	
	convert(otherCurrency: Currency): MoneyAmount {
		let newQuantity = this.quantity * this.currency.value / otherCurrency.value;
		return new MoneyAmount(newQuantity, otherCurrency);
	}
	
	toString() {
		return `${this.quantity.toFixed(2)} ${this.currency.name}`;
	}
}

const CURRENCIES = [
	new Currency("EUR", 1),
	new Currency("FRF", 1/6.55957),
	new Currency("USD", 1/1.14),
	new Currency("GBP", 1/0.9),
	new Currency("BTC", 1/0.0003) ];

@Component({
  selector: 'app-currency-converter',
  template: `<div>
	<form #currencyForm="ngForm">
		<input type="number" [(ngModel)]="moneyAmount.quantity" name="quantity" id="quantity">
		<select name="currency" id="currency" [(ngModel)]="moneyAmount.currency">
			<option *ngFor="let currency of currencies" [ngValue]="currency">{{ currency.name }}</option>
		</select>
	</form>
	<ul>
		<li *ngFor="let currency of currencies">{{ moneyAmount.convert(currency) }}</li>
	</ul>
	<button (click)="multiply(2)">Multiply by 2</button>
  </div>`,
  styleUrls: ['./currency-converter.component.css']
})
export class CurrencyConverterComponent {
	moneyAmount: MoneyAmount = new MoneyAmount(1, CURRENCIES[0]);
    currencies = CURRENCIES;
    
    multiply(factor) {
		this.moneyAmount.quantity *= 2;
	}
}
