import { Component, OnInit, Input } from '@angular/core';

@Component({
  selector: 'app-casino',
  template: `<div>
	<p>Welcome in the casino!</p>
	<app-slot-machine #machine [bet]="bet" (gain)="updateBalance($event)"></app-slot-machine>
	<div *ngIf="lastGain > 0">Congratulations, you won {{ lastGain }}</div>
	<div *ngIf="lastGain < 0">Sorry, you lost {{ -lastGain }}</div>
	Place your bet: <input [value]="bet" (input)="setBet($event.target.value)"> <br>
	<button *ngIf="balance >= bet" (click)="machine.doNewDraw()">Draw for a bet of {{ bet }}</button> <br>
	Balance of your account: {{ balance }}
  </div>
   `
})
export class CasinoComponent implements OnInit {
  
  @Input() initialBalance: number = 100;
  balance: number;
  bet = 0;
  lastGain = 0;

  ngOnInit() {
	this.balance = Math.floor(this.initialBalance);
  }
  
  setBet(bet) {
	bet = Math.floor(bet);
	if (! isNaN(bet)) this.bet = bet;
  }
  
  updateBalance(amount) {
    this.lastGain = amount;
	this.balance += amount;
  }
}
