import { BrowserModule } from '@angular/platform-browser';
import { NgModule } from '@angular/core';
import { FormsModule,  ReactiveFormsModule }   from '@angular/forms';
import { HttpClientModule } from '@angular/common/http';
import { RouterModule, Routes } from '@angular/router';

import { AppComponent } from './app.component';
import { HelloWorldComponent } from './hello-world/hello-world.component';
import { MutabilityComponent } from './mutability/mutability.component';
import { PersonComponent } from './person/person.component';
import { CoupleComponent } from './couple/couple.component';
import { DivmoveComponent } from './divmove/divmove.component';
import { SlotMachineComponent } from './slot-machine/slot-machine.component';
import { CasinoComponent } from './casino/casino.component';
import { CurrencyConverterComponent } from './currency-converter/currency-converter.component';
import { KeypadComponent } from './keypad/keypad.component';
import { TimestampComponent } from './timestamp/timestamp.component';
import { BitcoinTickerComponent } from './bitcoin-ticker/bitcoin-ticker.component';
import { PictureViewerComponent } from './picture-viewer/picture-viewer.component';
import { KeypadWrapperComponent } from './keypad-wrapper/keypad-wrapper.component';
import { DirectoryComponent } from './directory/directory.component';

const appRoutes: Routes = [
  { path: 'hello-world', component: HelloWorldComponent },
  { path: 'mutability',  component: MutabilityComponent },
  { path: 'couple', component: CoupleComponent },
  { path: 'divmove', component: DivmoveComponent },
  { path: 'casino', component: CasinoComponent },
  { path: 'currency-converter', component: CurrencyConverterComponent},
  { path: 'keypad', component: KeypadWrapperComponent },
  { path: 'directory', component: DirectoryComponent },
  { path: 'timestamp', component: TimestampComponent },
  { path: 'bitcoin', component: BitcoinTickerComponent },
  { path: 'picture/:width/:height', component: PictureViewerComponent }
];

@NgModule({
  declarations: [
    AppComponent,
    HelloWorldComponent,
    MutabilityComponent,
    PersonComponent,
    CoupleComponent,
    DivmoveComponent,
    SlotMachineComponent,
    CasinoComponent,
    CurrencyConverterComponent,
    KeypadComponent,
    TimestampComponent,
    BitcoinTickerComponent,
    PictureViewerComponent,
    KeypadWrapperComponent,
    DirectoryComponent
  ],
  imports: [
    BrowserModule,
    FormsModule, ReactiveFormsModule,
    HttpClientModule,
    RouterModule.forRoot(appRoutes, { enableTracing: true, useHash: true, relativeLinkResolution: 'legacy' })
  ],
  providers: [],
  bootstrap: [AppComponent]
})
export class AppModule { }
